﻿// FILE:         _FT_SideNav_Master_Startup.js
// DESCRIPTION:  Initialization for SideNav master pages.
// MODIFIED:     October 15, 2019
// VERSION:      FTFS 1.6 
// 
// © Copyright 2017-2019 Micro Focus or one of its affiliates.

$(function(){
			
	$(".vertical.menu.sidenav").each(function () {
				$(this).addClass("icons");		
				$(this).addClass("icon-left");		
			});
		
	// Set header title
	$(".sidenav-layout").on("loaded", function () { 	
		
		// Get help title from variable set in SideNav master page 
		var titleVariables = document.getElementById("ft-title-variable");
		var title = titleVariables.getAttribute("hdrTitle");
				
		// Add help title after header logo
		$('div.logo-wrapper').append("<div id=skinTitle><p id='skinTitle'>" + title + "</p></div>"); 			
	});	
	
	// Collapse footer
	$(".flex-container-footer").hide(); 	
		
	// Expand footer on click
	$(".footerToggle").click(function(e) {
		
		// Prevent default link click action			
		e.preventDefault();
				
		// If marked as open, remove class to close 
		if ( $(this).hasClass("is-open") ){
			$(this).removeClass("is-open").parent().parent().nextAll(".flex-container-footer").slideUp(500).removeClass("is-open");
					return;
		}
				
		// Mark as open and slide main footer into view				
		$(this).toggleClass("is-open");
				$(this).parent().parent().next(".flex-container-footer").slideToggle(500);
					
		$(".body-container").animate({ 			
			scrollTop: $(".body-container").height() + $(".flex-container-footer").height()
			}, 500);
	});	
		
	// Make footer visible (hidden in css) after moved to correct location.
	$("div.masterFooter").css("visibility", "visible");
		
});