﻿// FILE:         _FT_closeDDsAndTogglers.js
// DESCRIPTION:  Add close button to dropdowns.
// MODIFIED:     October 15, 2019
// VERSION:      FTFS 1.6 
// 
// © Copyright 2017-2019 Micro Focus or one of its affiliates. 

$(document).ready(function () {

	// Add close button to dropdowns 
	$(".dropDownBody").each(function () {

		// If styled for Close link or if on mobile, add the dropDownClose class
		if ( ($(this).hasClass("dropDownBodyCloseLink")) || ($(this).children(":first").hasClass("CloseLink")) ||
			( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) )) {
	
			// Add close button to dropdowns ("Close" text added via css) 
			$(this).append("<a href='javascript:void(0);' class='dropDownClose'></a>");
			$(".dropDownClose").click(function() {
				$(this).parent().prev(".dropDownHead").children(".dropDownHotspot").click();
			});
		}
	});

	// Add close button to togglers 
	$("[data-mc-target-name]").each(function() {
		
		// Get the previous sibling
		var togSibling = $(this).prev("p");
				
		// If the sibling's first child <a> is styled for Close link or if on mobile ...
		if ( togSibling.children(":first").hasClass("togglerCloseLink") ||
			( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) )) {
				
			// For each toggler target, find the target name (togglerTarget) 
			var togglerTarget = $(this).attr("data-mc-target-name");
				
			// For each toggler target, add a close link (a.togglerClose) ("Close" text added via css) 
			var closeTarget = ("<a href='javascript:void(0);' class='togglerClose'></a>");
			$(this).append(closeTarget);
				
			// Create a selector for the toggler link (closeToggler), which is linked to this target 
			// Look for open togglers, which include the togglerTarget name.
			var closeToggler = "a.MCToggler[data-mc-state='open'][data-mc-targets*='" + togglerTarget + "']";
					
			// When the closeTarget link is clicked, click the toggler link (closeToggler) 
			$(".togglerClose").click(function() {
				$(closeToggler).click();
			});
		}	
	});
					
});